function cb_m54
% Menu 54
% Display frequency response

  global f 
  global Rls
  global Cls
  global sfontsize 
  global persParamsDir   
  global puzFname
  global puDataDir 
  global m54
  global hdt
  
  capt = get(m54,'label');   
  
  pupFname=strrep(puzFname,'.puz','.pup');
   
  [fname, fpath, fltidx] = uigetfile({'*.pup','Open a PUP - file'}, ...
                           capt,strcat(puDataDir,pupFname));
   
  if fltidx > 0
   
    cancelMeasurement; 
   
    pupFname=fname;
    puzFname=strrep(pupFname,'.pup','.puz');
    puDataDir=fpath;
    sn = strcat(persParamsDir,'puDirFname.mat');
    save('-mat',sn,'puDataDir', 'puzFname');  
    
    loadname=strcat(puDataDir,pupFname);    
    planename=strrep(puzFname,'.puz','');
    titlename=[planename,': Frequency Response'];
    printname=strcat(puDataDir,planename,' FR.png');
    
    load(loadname,'-mat');
    
    ncoils = 1;
    if Ls(2) >0   
      ncoils =2;
      if Ls(3) > 0
        ncoils = 3;
      end  
    end     
    
    s=j*2*pi*f;
    
    Zc=0;
    for i=1:ncoils
      Zsc = s*Ls(i)./ (1 + s*Ls(i)/Rs(i));
      Zc=Zc+Zsc;   
    end
    
    U0 = Zc ./ s;
    Le=zeros(3,length(s));
    for i=1:3
      Rl=Rls(i);
      Cl=Cls(i);
      Zl = 1 ./ (1/Rl+ (Cl+C0)*s );    
      Ue = U0.*Zl ./ (Zc+R0+Zl);
      Ue = Ue ./ abs(Ue(1));
      Le(i,:) = 20*log10(abs(Ue));
      aux=[num2str(Rl/1000,4),' k\Omega, '];
      aux=[aux,num2str(Cl/1e-12,4), ' pF'];
      legendstr{i}=aux;
    end
   
    if ishandle(hdt) 
        delete(hdt) 
    end
   
    fa=f(1);
    fb=f(end);
    
    subplot(1,1,1)
    
    semilogx(f,Le)
    axis([fa fb -7 7])
    grid
    title(titlename);
    xlabel('Frequency / Hz')
    ylabel('Gain / dB')
    ha1=gca;
    
    lh=legend(legendstr,'location','southwest');
    set(lh,'units','pixels');     
    set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);  
    print('-dpng', printname,'-r300')
    
    set(ha1, 'fontsize',sfontsize); 
    
  end  
  
end